/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.skinsrestorer.shadow.aikar.commands.ACFUtil;
import net.skinsrestorer.shadow.aikar.commands.ACFVelocityUtil;
import net.skinsrestorer.shadow.aikar.commands.CommandContexts;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.InvalidCommandArgument;
import net.skinsrestorer.shadow.aikar.commands.MessageKeys;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandExecutionContext;
import net.skinsrestorer.shadow.aikar.commands.velocity.contexts.OnlinePlayer;
import net.skinsrestorer.shadow.aikar.locales.MessageKeyProvider;

public class VelocityCommandContexts
extends CommandContexts<VelocityCommandExecutionContext> {
    VelocityCommandContexts(ProxyServer server, CommandManager manager) {
        super(manager);
        this.registerContext(OnlinePlayer.class, c -> this.getOnlinePlayer(server, (VelocityCommandExecutionContext)c));
        this.registerContext(net.skinsrestorer.shadow.aikar.commands.contexts.OnlinePlayer.class, c -> {
            OnlinePlayer onlinePlayer = this.getOnlinePlayer(server, (VelocityCommandExecutionContext)c);
            return new net.skinsrestorer.shadow.aikar.commands.contexts.OnlinePlayer(onlinePlayer.getPlayer());
        });
        this.registerIssuerAwareContext(CommandSource.class, VelocityCommandExecutionContext::getSender);
        this.registerIssuerAwareContext(Player.class, c -> {
            Player proxiedPlayer;
            Player player = proxiedPlayer = c.getSender() instanceof Player ? (Player)c.getSender() : null;
            if (proxiedPlayer == null && !c.isOptional()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            return proxiedPlayer;
        });
        this.registerContext(TextFormat.class, c -> {
            TextColor match;
            String filter;
            String first = c.popFirstArg();
            Stream<TextFormat> colors = NamedTextColor.NAMES.values().stream().map(namedTextColor -> namedTextColor);
            if (!c.hasFlag("colorsonly")) {
                colors = Stream.concat(colors, Stream.of(TextDecoration.values()));
            }
            if ((filter = c.getFlagValue("filter", (String)null)) != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                colors = colors.filter(color -> finalFilter.equals(ACFUtil.simplifyString(color.toString())));
            }
            if ((match = (TextColor)NamedTextColor.NAMES.value((Object)ACFUtil.simplifyString(first))) == null) {
                String valid = colors.map(color -> "<c2>" + ACFUtil.simplifyString(color.toString()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            }
            return match;
        });
    }

    private OnlinePlayer getOnlinePlayer(ProxyServer server, VelocityCommandExecutionContext c) throws InvalidCommandArgument {
        Player proxiedPlayer = ACFVelocityUtil.findPlayerSmart(server, c.getIssuer(), c.popFirstArg());
        if (proxiedPlayer == null) {
            throw new InvalidCommandArgument(false);
        }
        return new OnlinePlayer(proxiedPlayer);
    }
}

